#!/bin/sh

################################################################
# wrapper which first loads the applicable Qt 5 libraries
# before running ChromaMate
#
# FROM: https://doc.qt.io/qt-5/linux-deployment.html
################################################################

appname=`basename $0 | sed s,\.sh$,,`

dirname=`dirname $0`
tmp="${dirname#?}"

if [ "${dirname%$tmp}" != "/" ]; then
dirname=$PWD/$dirname
fi

libdirname=$dirname/qt

export LD_PRELOAD="$libdirname/libQt5Core.so.5 $libdirname/libQt5DBus.so.5 $libdirname/libQt5Gui.so.5 $libdirname/libQt5Help.so.5 $libdirname/libQt5PrintSupport.so.5 $libdirname/libQt5Sql.so.5 $libdirname/libQt5Network.so.5 $libdirname/libQt5Widgets.so.5 $libdirname/libQt5XcbQpa.so.5 $libdirname/libicui18n.so.56 $libdirname/libicuuc.so.56 $libdirname/libicudata.so.56"
export QT_PLUGIN_PATH=$libdirname/plugins


$dirname/$appname "$@"
